/* FILE: mdt28xx.h                              (D. Tottingham  04/07/91)

This is an include file of the defines, data structure definitions and
external data declarations for using the mdt28xx module.

*/

#ifndef _MDT28XX_
#define _MDT28XX_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mqueue.h"


/************************************************************************
                                DEFINES

************************************************************************/
/* Defaults */
#define CHANNEL_GAIN            4
#define CLOCK_SOURCE            INTERNAL_CLOCK
#define DIGITIZATION_RATE       100.0           /* Samples/sec/channel */
#define TIME_OUT                10
#define TRIGGER_SOURCE          INTERNAL_TRIGGER

/* Buffer Constants */
#define MAX_BUFFER_SIZE         16384L


/************************************************************************
                        STRUCTURE DEFINITIONS


************************************************************************/
typedef struct {
        int far * channel_list;
        int far * gain_list;
        SUDS_STRUCTTAG structtag;
        SUDS_ATODINFO  info;
} DT_28XX;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC FLAG dt_buffer_full ();
PUBLIC void dt_dump_configuration (FILE *);
PUBLIC DT_28XX far * dt_get_atodinfo ();
PUBLIC unsigned int dt_get_bankswitch_count ();
PUBLIC unsigned long dt_get_buffer_size ();
PUBLIC unsigned long dt_get_channel_size ();
PUBLIC unsigned int dt_get_channel_gain (unsigned int);
PUBLIC unsigned long dt_get_clip_value ();
PUBLIC char dt_get_clock_source ();
PUBLIC char dt_get_data_type ();
PUBLIC char dt_get_data_units ();
PUBLIC unsigned int dt_get_dc_offset ();
PUBLIC double dt_get_digitization_rate ();
PUBLIC unsigned int dt_get_input_range ();
PUBLIC void dt_get_new_buffers ();
PUBLIC Q_BUFFER far * dt_get_next_buffer ();
PUBLIC int dt_get_number_of_ext_buffers ();
PUBLIC int dt_get_scan_count ();
PUBLIC char dt_get_trigger_source ();
PUBLIC void dt_initialize_buffers ();
PUBLIC void dt_initialize_params();
PUBLIC FLAG dt_set_channel (unsigned int, unsigned int);
PUBLIC void dt_set_ChannelBlocksize (unsigned long);
PUBLIC void dt_set_ChannelGain (unsigned int);
PUBLIC void dt_set_ClockSource (int);
PUBLIC void dt_set_DigitizationRate (double);
PUBLIC void dt_set_mux_type (unsigned int);
PUBLIC void dt_set_TriggerSource (int);
PUBLIC void dt_start_ADC ();
PUBLIC void dt_stop_ADC ();

#endif
